package ru.yandex.client.wmi;

import java.util.function.Function;

import ru.yandex.http.util.RequestErrorType;

public enum FilterSearchErrorClassifier
    implements Function<Exception, RequestErrorType>
{
    INSTANCE;

    public static boolean nonRecoverableFilterSearchError(final Exception e) {
        return e instanceof CouldNotUtfizeStringException
            || e instanceof UserNotInitializedException;
    }

    @Override
    public RequestErrorType apply(final Exception e) {
        if (nonRecoverableFilterSearchError(e)) {
            return RequestErrorType.NON_RETRIABLE;
        } else {
            return RequestErrorType.ERROR_CLASSIFIER.apply(e);
        }
    }
}

