package ru.yandex.client.wmi;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.FilterFutureCallback;

public class FilterSearchErrorSuppressingFutureCallback<T>
    extends FilterFutureCallback<T>
{
    private final T defaultValue;
    private final Logger logger;

    public FilterSearchErrorSuppressingFutureCallback(
        final FutureCallback<? super T> callback,
        final T defaultValue,
        final Logger logger)
    {
        super(callback);
        this.defaultValue = defaultValue;
        this.logger = logger;
    }

    @Override
    public void failed(final Exception e) {
        if (FilterSearchErrorClassifier.nonRecoverableFilterSearchError(e)) {
            logger.log(
                Level.WARNING,
                "Unrecoverable error in /filter_search, replacing result with "
                + "empty envelopes list",
                e);
            completed(defaultValue);
        } else {
            super.failed(e);
        }
    }
}

