package ru.yandex.client.wmi;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.json.dom.JsonList;

public enum FilterSearchJsonResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory<JsonList>
{
    INSTANCE;

    public static final HttpAsyncResponseConsumerFactory<JsonList>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public FilterSearchJsonResponseConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new FilterSearchJsonResponseConsumer(response.getEntity());
    }
}

