package ru.yandex.client.wmi;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;

import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.search.document.mail.FirstlineMailMetaInfo;
import ru.yandex.search.document.mail.JsonFirstlineMailMetaHandler;
import ru.yandex.search.document.mail.MailMetaInfo;

public class FilterSearchResponseConsumer
    extends FilterSearchResponseConsumerBase<List<FirstlineMailMetaInfo>>
{
    private final String uid;
    private final String lcn;

    public FilterSearchResponseConsumer(
        final HttpEntity entity,
        final String uid,
        final String lcn)
        throws HttpException
    {
        super(entity);
        this.uid = uid;
        this.lcn = lcn;
    }

    @Override
    protected List<FirstlineMailMetaInfo> convertEnvelopes(
        final JsonList envelopes)
        throws Exception
    {
        List<FirstlineMailMetaInfo> result =
            new ArrayList<>(envelopes.size());
        for (JsonObject envelope: envelopes) {
            FirstlineMailMetaInfo meta = new FirstlineMailMetaInfo();
            new JsonFirstlineMailMetaHandler(meta).handle(envelope.asMap());
            meta.set(MailMetaInfo.UID, uid);
            if (lcn != null) {
                meta.set(MailMetaInfo.LCN, lcn);
            }
            result.add(meta);
        }
        return result;
    }
}

