package ru.yandex.client.wmi;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.KeyInterningStringCollectorsFactory;

public abstract class FilterSearchResponseConsumerBase<T>
    extends AbstractJsonAsyncTypesafeDomConsumer<T>
{
    private static final int USER_IS_NOT_INITIALIZED = 1006;

    protected FilterSearchResponseConsumerBase(final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            KeyInterningStringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    protected abstract T convertEnvelopes(final JsonList envelopes)
        throws Exception;

    @Override
    protected T buildResult(final HttpContext context, final JsonObject value)
        throws Exception
    {
        JsonMap root = value.asMap();
        JsonMap error = root.getMapOrNull("error");
        if (error == null) {
            return convertEnvelopes(root.getList("envelopes"));
        } else {
            switch (error.getInt("code")) {
                case 1:
                    String message = error.getString("message", null);
                    if ("unknown error".equals(message)) {
                        String reason = error.getString("reason", "");
                        if (reason.startsWith("could not utfize string.")) {
                            throw new CouldNotUtfizeStringException(error);
                        }
                    }
                    break;
                case USER_IS_NOT_INITIALIZED:
                    throw new UserNotInitializedException(error);
                default:
                    break;
            }
            throw new FilterSearchException(error);
        }
    }
}

