package ru.yandex.client.wmi;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.search.document.mail.FirstlineMailMetaInfo;

public class FilterSearchResponseConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<FirstlineMailMetaInfo>>
{
    private final String uid;
    private final String lcn;

    public FilterSearchResponseConsumerFactory(
        final long uid,
        final String lcn)
    {
        this.uid = Long.toString(uid);
        this.lcn = lcn;
    }

    @Override
    public FilterSearchResponseConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new FilterSearchResponseConsumer(
            response.getEntity(),
            uid,
            lcn);
    }
}

