package ru.yandex.client.wmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericFunction;
import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.search.request.util.SearchRequestText;

public class FoldersConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Folders>
{
    private static final GenericFunction<JsonMap, String, JsonException>
        DEFAULT_PROCESSOR =
            folder -> SearchRequestText.normalize(
                folder.get("name").asString().toLowerCase(Locale.ROOT));

    private final GenericFunction<JsonMap, String, JsonException> processor;

    public FoldersConsumer(
        final GenericFunction<JsonMap, String, JsonException> processor,
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);

        this.processor = processor;
    }

    public FoldersConsumer(final HttpEntity entity) throws HttpException {
        this(DEFAULT_PROCESSOR, entity);
    }

    @Override
    protected Folders buildResult(
        final HttpContext context,
        final JsonObject root)
        throws Exception
    {
        Map<String, List<String>> fids = new HashMap<>();
        Map<String, String> fidToName = new HashMap<>();
        Function<String, List<String>> listFactory = x -> new ArrayList<>();
        for (Map.Entry<String, JsonObject> folder
            : root.get("folders").asMap().entrySet())
        {
            JsonMap map = folder.getValue().asMap();

            String name = processor.apply(map);
            if (name != null) {
                String fid = folder.getKey();

                fidToName.put(fid, name);
                fids.computeIfAbsent(name, listFactory).add(fid);
                int idx = name.lastIndexOf('|');
                if (idx != -1) {
                    fids.computeIfAbsent(name.substring(idx + 1), listFactory)
                        .add(fid);
                }
            }
        }
        return new Folders(fids, fidToName);
    }
}

