package ru.yandex.client.wmi;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum FoldersConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Folders>
{
    INSTANCE;

    public static final StatusCheckAsyncResponseConsumerFactory<Folders> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public FoldersConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new FoldersConsumer(response.getEntity());
    }
}

