package ru.yandex.client.wmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericFunction;
import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.search.request.util.SearchRequestText;

public class LabelsConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Labels>
{
    private static final String TITLE = "title";
    private static final GenericFunction<JsonMap, String, JsonException>
        DEFAULT_PROCESSOR =
            label -> SearchRequestText.normalize(
                label.get("name").asString().toLowerCase(Locale.ROOT));

    private final GenericFunction<JsonMap, String, JsonException> processor;

    public LabelsConsumer(
        final GenericFunction<JsonMap, String, JsonException> processor,
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);

        this.processor = processor;
    }

    public LabelsConsumer(
        final HttpEntity entity)
        throws HttpException
    {
        this(DEFAULT_PROCESSOR, entity);
    }

    @Override
    protected Labels buildResult(
        final HttpContext context,
        final JsonObject root)
        throws Exception
    {
        Map<String, List<String>> lids = new HashMap<>();
        String importantLid = null;
        String hamonLid = null;
        Function<String, List<String>> listFactory = x -> new ArrayList<>();
        for (Map.Entry<String, JsonObject> label
            : root.get("labels").asMap().entrySet())
        {
            JsonMap map = label.getValue().asMap();
            String type = map.get("type").get(TITLE).asString();
            if ("system".equals(type)) {
                String title = map.get("symbolicName").get(TITLE).asString();
                if ("important_label".equals(title)) {
                    importantLid = label.getKey();
                } else if ("hamon_label".equals(title)) {
                    hamonLid = label.getKey();
                }
            } else if ("user".equals(type)) {
                lids.computeIfAbsent(
                    processor.apply(map),
                    listFactory)
                    .add(label.getKey());
            }
        }

        return new Labels(lids, importantLid, hamonLid);
    }
}

