#!/bin/bash
set -exo pipefail

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export MTN_TAG=$(hostname -s)
export CONSUMER_PREFETCH_COUNT=250
export SERVICE_CONFIG=null.conf
export BLOCK_CASHE_SIZE="2G"
export COMPRESSED_CASHE_SIZE="2G"
export CPU_CORES_CORRECTION="0.2"

case "$NANNY_SERVICE_ID" in
    messenger_chats_search_prod_load*)
        export GZIP=./fakegzip.sh
        export CONSUMER_PREFETCH_COUNT=300
        export SERVICE_CONFIG=chats_backend_load.conf
        export BLOCK_CASHE_SIZE="3G"
        export COMPRESSED_CASHE_SIZE="2G"
        export CPU_CORES_CORRECTION="0.2"
        ;;
    messenger_chats_search_backend_prod*)
        export CPU_CORES_CORRECTION="1.2"
        export BLOCK_CASHE_SIZE="3G"
        export COMPRESSED_CASHE_SIZE="3G"
        ;;
    messenger_chats_search_backend_alpha*)
        export CPU_CORES_CORRECTION="1.2"
        export BLOCK_CASHE_SIZE="1G"
        export COMPRESSED_CASHE_SIZE="1G"
        ;;
    *)
        ;;
esac
