package ru.yandex.ps.messenger.search;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.msearch.collector.docprocessor.ModuleFieldsAggregator;
import ru.yandex.util.string.StringUtils;

public class KeepPvpUsersDocProcessor extends KeepPvpChatsDocProcessor {
    private final String owner;
    protected final String outField;
    protected final Set<String> outFields;
    protected final int outFieldIndex;

    public KeepPvpUsersDocProcessor(
        final String args,
        final ProcessorRequestContext context)
        throws ParseException
    {
        super(args, context);

        int index = args.indexOf(' ');
        if (index < 0 || index >= args.length() - 1) {
            throw new ParseException("Invalid args, expecting guid + outField", index);
        }

        owner = args.substring(0, index);
        outField = StringHelper.intern(args.substring(index + 1));
        this.outFieldIndex = context.fieldToIndex().indexFor(this.outField);
        this.outFields = Collections.singleton(this.outField);
    }

    @Override
    public boolean processWithFilter(final YaDoc3 doc) throws IOException {
        YaField yaField = doc.getField(fieldIndex);
        if (yaField == null) {
            return false;
        }

        String chatId = yaField.toString();
        if (PvpChatPredicate.INSTANCE.test(chatId)) {
            int underscoreIndex = chatId.indexOf('_');
            if (underscoreIndex < 0 || underscoreIndex >= chatId.length() - 1) {
                return false;
            }

            String other;
            String first = chatId.substring(0, underscoreIndex);
            if (owner.equalsIgnoreCase(first)) {
                other = chatId.substring(underscoreIndex + 1);
            } else {
                other = first;
            }

            doc.setField(
                outFieldIndex,
                new YaField.StringYaField(StringUtils.getUtf8Bytes(other)));

            return true;
        }

        return false;
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(loadFields, outFields);
    }
}
