package ru.yandex.ps.messenger.search;

import java.text.ParseException;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.docprocessor.DocProcessorType;

public enum MessengerChatsDocProcessorType implements DocProcessorType {
    KEEP_PVP {
        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new KeepPvpChatsDocProcessor(args, context);
        }

        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }
    },
    KEEP_PVP_USERS {
        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new KeepPvpUsersDocProcessor(args, context);
        }

        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }
    },
}
