package ru.yandex.ps.messenger.search;

import java.util.function.Predicate;

import ru.yandex.msearch.collector.YaField;

public enum PvpChatPredicate implements Predicate<YaField> {
    INSTANCE;

    @Override
    public boolean test(final YaField yaField) {
        if (yaField == null) {
            return false;
        }

        return test(yaField.toString());
    }

    public boolean test(final String value) {
        if (value == null) {
            return false;
        }

        return value.indexOf('/') < 0;
    }
}
