#!/bin/bash
set -xo pipefail

export SERVICE_PORT=$BSCONFIG_IPORT
export READ_ONLY_LOCAL=false
export SERVICE_CONFIG="empty.conf"

case "$NANNY_SERVICE_ID" in
    messenger_search_logbroker_consumer_test)
        export TARGET_URI=http://messenger-search-malo-test.n.yandex-team.ru/
        export CLIENT_ID=mssngr-search-indexation-test-client
        export TOPICS=mssngr--test-search-chats,mssngr--test-search-users,mssngr--test-search-messages,mssngr--test-search-contacts,mssngr--test-search-chat-members,mssngr--test-search-buckets
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2001772
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=50
        ;;
    messenger_search_logbroker_consumer2_test)
        export TARGET_URI=http://messenger-search-malo-test.n.yandex-team.ru/
        export CLIENT_ID=/mssngr/test/search/indexation-client
        export TOPICS=/mssngr/test/search/chats,/mssngr/test/search/users,/mssngr/test/search/messages,/mssngr/test/search/contacts,/mssngr/test/search/chat-members,/mssngr/test/search/buckets
        export BALANCER_HOSTS=lbkx.logbroker.yandex.net
        export SRC_CLIENT_ID=2001772
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=50
        ;; 
    messenger_search_logbroker_consumer_prod)
        export TARGET_URI=http://messenger-malo.pers.yandex.net:12929/
        export CLIENT_ID=mssngr-search-indexation-prod-client
        export TOPICS=mssngr--prod-search-chats,mssngr--prod-search-users,mssngr--prod-search-messages,mssngr--prod-search-contacts,mssngr--prod-search-chat-members,mssngr--prod-search-buckets
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2001774
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=200
        export SERVICE_CONFIG="messenger.conf"
        ;;
    messenger_search_logbroker_consumer2_prod)
        export TARGET_URI=http://messenger-malo.pers.yandex.net:12929/
        export CLIENT_ID=/mssngr/prod/search/indexation-client
        export TOPICS=/mssngr/prod/search/chats,/mssngr/prod/search/users,/mssngr/prod/search/messages,/mssngr/prod/search/contacts,/mssngr/prod/search/chat-members,/mssngr/prod/search/buckets,/mssngr/prod/search/groups,/mssngr/prod/search/departments
        export BALANCER_HOSTS=lbkx.logbroker.yandex.net
        export SRC_CLIENT_ID=2001774
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=50
        export SERVICE_CONFIG="messenger.conf"
        ;; 
    messenger_search_logbroker_consumer_alpha)
        export TARGET_URI=http://messenger-malo-alpha.pers.yandex.net:26895/
        export CLIENT_ID=mssngr-search-indexation-alpha-client
        export TOPICS=mssngr--alpha-search-chats,mssngr--alpha-search-users,mssngr--alpha-search-messages,mssngr--alpha-search-contacts,mssngr--alpha-search-chat-members,mssngr--alpha-search-buckets,,mssngr--alpha-search-groups,mssngr--alpha-search-departments
        export BALANCER_HOSTS=messenger.logbroker.yandex.net
        export SRC_CLIENT_ID=2002052
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=50
        export SERVICE_CONFIG="messenger.conf"
        ;;
    messenger_search_logbroker_consumer2_alpha)
        export TARGET_URI=http://messenger-malo-alpha.pers.yandex.net:26895/
        export CLIENT_ID=/mssngr/alpha/search/indexation-client
	export TOPICS=/mssngr/alpha/search/chats,/mssngr/alpha/search/users,/mssngr/alpha/search/messages,/mssngr/alpha/search/contacts,/mssngr/alpha/search/chat-members,/mssngr/alpha/search/buckets
        export BALANCER_HOSTS=lbkx.logbroker.yandex.net
        export SRC_CLIENT_ID=2002052
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=50
        export SERVICE_CONFIG="messenger.conf"
        ;; 
    mail-logbroker-consumer-prod)
        export TARGET_URI=http://iex-proxy-prod3.n.yandex-team.ru/calendar-log-handle
        export CLIENT_ID=/mail-search/calendar-consumer
        export TOPICS=calendar-public--calendar-public-events-log-json,calendar-yt--calendar-yt-events-log-json
        export BALANCER_HOSTS=sas.logbroker.yandex.net,man.logbroker.yandex.net,myt.logbroker.yandex.net,iva.logbroker.yandex.net,vla.logbroker.yandex.net
        export READ_ONLY_LOCAL=true
        export SRC_CLIENT_ID=2000031
        export LB_TVM_CLIENT_ID=2001059
        export SEND_BATCH_SIZE=1
        export SERVICE_PORT=$((BSCONFIG_IPORT+1))
        ;;
esac
