#!/bin/bash
source config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
#export LD_PRELOAD=$BSCONFIG_IDIR/libtcmalloc_minimal.so

DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
GC_ARGS="-Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/dev/shm/gclogs/gc#.log,10,10000"
MEM_ARGS="-Xmx4G -Xms2G -Xmn384M"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=.:logbroker_consumer_service \
    -cp $CLASSPATH \
    ru.yandex.logbroker2.Logbroker2Consumer \
    consumer.conf
