package ru.yandex.search.messenger.indexer;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMaloConfigBuilder
    <T extends AbstractMaloConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements MaloConfig
{
    private static final String SERVICE_NAME = "service-name";

    private HttpHostConfigBuilder producer;
    private HttpHostConfigBuilder mailProducer;
    private HttpHostConfigBuilder moxy;
    private HttpHostConfigBuilder malo;
    private HttpHostConfigBuilder rca;
    private URIConfigBuilder cmntApi;
    private URIConfigBuilder chats;
    private URIConfigBuilder messages;
    private URIConfigBuilder users;
    private String chatsService;
    private String chatsTasksService;
    private String messagesService;
    private String usersService;
    private String tasksService;
    private String mailMessagesService;
    private String v2OrgUserService;
    private String v2OrgChatsService;
    private Tvm2ClientConfigBuilder metaApiTvm2ClientConfig;
    private Tvm2ClientConfigBuilder messengerRouterTvm2ClientConfig;
    private Tvm2ClientConfigBuilder cmntApiTvm2ClientConfig;

    protected AbstractMaloConfigBuilder(
        final MaloConfig config)
        throws ConfigException
    {
        super(config);
        producer = new HttpHostConfigBuilder(config.producer());
        mailProducer = new HttpHostConfigBuilder(config.mailProducer());
        moxy = new HttpHostConfigBuilder(config.moxy());
        malo = new HttpHostConfigBuilder(config.malo());
        rca = new HttpHostConfigBuilder(config.rca());
        cmntApi = new URIConfigBuilder(config.cmntApi());
        chats = new URIConfigBuilder(config.chats());
        messages = new URIConfigBuilder(config.messages());
        users = new URIConfigBuilder(config.users());
        chatsService = config.chatsService();
        messagesService = config.messagesService();
        usersService = config.usersService();
        tasksService = config.tasksService();
        chatsTasksService = config.chatsTasksService();
        mailMessagesService = config.mailMessagesService();
        cmntApiTvm2ClientConfig =
            new Tvm2ClientConfigBuilder(
                config.cmntApiTvm2ClientConfig());
        v2OrgChatsService = config.v2OrgChatsService();
        v2OrgUserService = config.v2OrgUserService();
    }

    protected AbstractMaloConfigBuilder(
        final IniConfig config,
        final MaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        producer =
            new HttpHostConfigBuilder(
                config.section("producer"),
                defaults.producer());
        IniConfig mailProducerSection =
            config.sectionOrNull("mail-producer");
        if (mailProducerSection == null) {
            mailProducer = null;
            malo = null;
        } else {
            mailProducer =
                new HttpHostConfigBuilder(
                    mailProducerSection,
                    defaults.mailProducer());
            malo =
                new HttpHostConfigBuilder(
                    config.section("malo"),
                    defaults.malo());
        }
        IniConfig rcaSection =
            config.sectionOrNull("rca");
        if (rcaSection == null) {
            rca = null;
        } else {
            rca =
                new HttpHostConfigBuilder(
                    rcaSection,
                    defaults.rca());
        }
        IniConfig cmntApiSection =
            config.sectionOrNull("cmnt-api");
        if (cmntApiSection == null) {
            cmntApi = null;
            cmntApiTvm2ClientConfig = null;
        } else {
            cmntApi =
                new URIConfigBuilder(
                    cmntApiSection,
                    defaults.cmntApi());
            IniConfig cmntTvm = config.sectionOrNull("tvm2.cmnt-api");
            if (cmntTvm != null) {
                cmntApiTvm2ClientConfig = new Tvm2ClientConfigBuilder(
                    cmntTvm,
                    defaults.cmntApiTvm2ClientConfig());
            } else {
                cmntApiTvm2ClientConfig = null;
            }
        }
        moxy =
            new HttpHostConfigBuilder(
                config.section("moxy"),
                defaults.moxy());
        IniConfig chatsConfig = config.section("chats");
        chats = new URIConfigBuilder(chatsConfig, defaults.chats());
        chatsService =
            chatsConfig.getString(SERVICE_NAME, defaults.chatsService());
        IniConfig messagesConfig = config.section("messages");
        messages = new URIConfigBuilder(messagesConfig, defaults.messages());
        messagesService =
            messagesConfig.getString(SERVICE_NAME, defaults.messagesService());
        IniConfig usersConfig = config.section("users");
        users = new URIConfigBuilder(usersConfig, defaults.users());
        usersService =
            usersConfig.getString(SERVICE_NAME, defaults.usersService());

        tasksService =
            config.getString("tasks-service-name", defaults.tasksService());
        chatsTasksService =
            config.getString("chats-tasks-service-name", defaults.chatsTasksService());
        v2OrgUserService =
            config.getString("v2-org-user-service-name", defaults.v2OrgUserService());
        v2OrgChatsService =
            config.getString("v2-org-chat-service-name", defaults.v2OrgChatsService());

        mailMessagesService =
            config.getString(
                "mail-messages-service",
                defaults.messagesService());
    }

    @Override
    public HttpHostConfigBuilder producer() {
        return producer;
    }

    public T producer(final HttpHostConfig producer) {
        this.producer = new HttpHostConfigBuilder(producer);
        return self();
    }

    @Override
    public HttpHostConfigBuilder mailProducer() {
        return mailProducer;
    }

    public T mailProducer(final HttpHostConfig mailProducer) {
        this.mailProducer = new HttpHostConfigBuilder(mailProducer);
        return self();
    }

    @Override
    public HttpHostConfigBuilder rca() {
        return rca;
    }

    public T rca(final HttpHostConfig rca) {
        this.rca = new HttpHostConfigBuilder(rca);
        return self();
    }

    @Override
    public URIConfigBuilder cmntApi() {
        return cmntApi;
    }

    public T cmntApi(final URIConfig cmntApi) {
        this.cmntApi = new URIConfigBuilder(cmntApi);
        return self();
    }

    @Override
    public HttpHostConfigBuilder moxy() {
        return moxy;
    }

    public T moxy(final HttpHostConfig moxy) {
        this.moxy = new HttpHostConfigBuilder(moxy);
        return self();
    }

    @Override
    public HttpHostConfigBuilder malo() {
        return malo;
    }

    public T malo(final HttpHostConfig malo) {
        this.malo = new HttpHostConfigBuilder(malo);
        return self();
    }

    @Override
    public URIConfigBuilder chats() {
        return chats;
    }

    public T chats(final URIConfig chats) {
        this.chats = new URIConfigBuilder(chats);
        return self();
    }

    @Override
    public String chatsService() {
        return chatsService;
    }

    public T chatsService(final String chatsService) {
        this.chatsService = chatsService;
        return self();
    }

    @Override
    public URIConfigBuilder messages() {
        return messages;
    }

    public T messages(final URIConfig messages) {
        this.messages = new URIConfigBuilder(messages);
        return self();
    }

    @Override
    public String messagesService() {
        return messagesService;
    }

    public T messagesService(final String messagesService) {
        this.messagesService = messagesService;
        return self();
    }

    @Override
    public URIConfigBuilder users() {
        return users;
    }

    public T users(final URIConfig users) {
        this.users = new URIConfigBuilder(users);
        return self();
    }

    @Override
    public String usersService() {
        return usersService;
    }

    public T usersService(final String usersService) {
        this.usersService = usersService;
        return self();
    }

    @Override
    public String tasksService() {
        return tasksService;
    }

    public T tasksService(final String tasksService) {
        this.tasksService = tasksService;
        return self();
    }

    @Override
    public String mailMessagesService() {
        return mailMessagesService;
    }

    public T mailMessagesService(final String mailMessagesService) {
        this.mailMessagesService = mailMessagesService;
        return self();
    }

    @Override
    public String v2OrgUserService() {
        return v2OrgUserService;
    }

    public T v2OrgUserService(final String v2OrgUserService) {
        this.v2OrgUserService = v2OrgUserService;
        return self();
    }

    @Override
    public String v2OrgChatsService() {
        return v2OrgChatsService;
    }

    public T v2OrgChatsService(final String v2OrgChatsService) {
        this.v2OrgChatsService = v2OrgChatsService;
        return self();
    }

    @Override
    public String chatsTasksService() {
        return chatsTasksService;
    }

    public T chatsTasksService(final String chatsTasksService) {
        this.chatsTasksService = chatsTasksService;
        return self();
    }

    @Override
    public Tvm2ClientConfigBuilder cmntApiTvm2ClientConfig() {
        return cmntApiTvm2ClientConfig;
    }

    public T cmntApiTvm2ClientConfig(
        final Tvm2ClientConfig cmntApiTvm2ClientConfig)
    {
        if (cmntApiTvm2ClientConfig == null) {
            this.cmntApiTvm2ClientConfig = null;
        } else {
            this.cmntApiTvm2ClientConfig =
                new Tvm2ClientConfigBuilder(cmntApiTvm2ClientConfig);
        }
        return self();
    }

    public void copyTo(final AbstractMaloConfigBuilder<?> other) {
        copyTo((AbstractHttpProxyConfigBuilder<?>) other);
        other.producer(producer);
        other.mailProducer(mailProducer);
        other.chats(chats);
        other.messages(messages);
        other.chatsService(chatsService);
        other.messagesService(messagesService);
        other.mailMessagesService(mailMessagesService);
    }
}
