package ru.yandex.search.messenger.indexer;

import java.io.IOException;

import org.apache.http.HttpException;

public class ChatMembersDiffSession extends IndexSession {
    private static final String INDEX_METHOD = "chat_members";
    private final String chatId;
    protected final Long orgId;
    private final boolean reindex;

    public ChatMembersDiffSession(
        final MaloRequest request,
        final String chatId,
        final Long orgId)
        throws HttpException, IOException
    {
        super(request);
        this.chatId = chatId;
        this.reindex = false;
        this.orgId = orgId;
        info(MaloYtField.INDEX_METHOD, INDEX_METHOD);
        info(MaloYtField.REINDEX, Boolean.toString(reindex));
        info(MaloYtField.CHAT_ID, chatId);
    }

    public ChatMembersDiffSession(
        final MaloRequest request,
        final String chatId,
        final Long orgId,
        final boolean reindex)
        throws HttpException, IOException
    {
        super(request);
        this.chatId = chatId;
        this.reindex = reindex;
        this.orgId = orgId;
        info(MaloYtField.INDEX_METHOD, INDEX_METHOD);
        info(MaloYtField.REINDEX, Boolean.toString(reindex));
        info(MaloYtField.CHAT_ID, chatId);
    }

    public String chatId() {
        return chatId;
    }

    public boolean reindex() {
        return reindex;
    }

    public Long orgId() {
        return orgId;
    }
}
