package ru.yandex.search.messenger.indexer;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;

public abstract class ChatMembersMessage extends IndexableMessage {
    protected final String chatId;

    public ChatMembersMessage(final String chatId) {
        super(true);
        this.chatId = chatId;
    }

    public ChatMembersMessage(final String chatId, final boolean addIfNotExists) {
        super(addIfNotExists);
        this.chatId = chatId;
    }

    @Override
    public String id() {
        return "chat_" + chatId;
    }

    @Override
    public String type() {
        return "chat";
    }

    protected JsonObject jsonFunction(
        final String function,
        final String arg1) {
        return jsonFunction(function, new JsonString(arg1));
    }

    protected JsonObject jsonFunction(
        final String function,
        final String arg1,
        final JsonObject arg2) {
        return jsonFunction(function, new JsonString(arg1), arg2);
    }

    protected JsonObject jsonFunction(
        final String function,
        final JsonObject arg1,
        final String arg2) {
        return jsonFunction(function, arg1, new JsonString(arg2));
    }

    protected JsonObject jsonFunction(
        final String function,
        final JsonObject arg1,
        final String arg2,
        final String arg3) {
        return jsonFunction(
            function,
            arg1,
            new JsonString(arg2),
            new JsonString(arg3));
    }

    protected JsonObject jsonFunction(
        final String function,
        final String... args) {
        JsonMap func = new JsonMap(BasicContainerFactory.INSTANCE);
        func.put("function", new JsonString(function));
        JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
        for (String arg : args) {
            list.add(new JsonString(arg));
        }
        func.put("args", list);
        return func;
    }

    protected JsonObject jsonFunction(
        final String function,
        final JsonObject... args) {
        JsonMap func = new JsonMap(BasicContainerFactory.INSTANCE);
        func.put("function", new JsonString(function));
        JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
        for (JsonObject arg : args) {
            list.add(arg);
        }
        func.put("args", list);
        return func;
    }

}
