package ru.yandex.search.messenger.indexer;

public abstract class ChatMessage extends IndexableMessage {
    protected final String chatId;

    public ChatMessage(final String chatId, final boolean addIfNotExists) {
        super(addIfNotExists);
        this.chatId = chatId;
    }

    @Override
    public String id() {
        return "chat_" + chatId;
    }

    @Override
    public String type() {
        return "chat";
    }
}
