package ru.yandex.search.messenger.indexer;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.writer.Utf8JsonWriter;
import ru.yandex.ps.search.messenger.UserFields;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.util.string.StringUtils;

public class ClearChatMessage extends UserMessage {
    private final String chatId;
    private final long ts;

    public ClearChatMessage(
        final String guid,
        final String chatId,
        final long ts)
    {
        super(new LongPrefix(0L), guid, false);

        this.chatId = chatId;
        this.ts = ts;
    }

    @Override
    protected void writeGetFields(
        final Utf8JsonWriter writer,
        final Set<String> fields)
        throws IOException
    {
    }

    @Override
    public String updateRequest() {
        return "user_id:" + userId;
    }

    @Override
    public boolean writeIdField() {
        return false;
    }

    @Override
    protected void writeDocumentFields(
        final Utf8JsonWriter writer)
        throws IOException
    {
        writer.key(UserFields.CLEARED_CHATS.stored());
        writer.startObject();
        writer.key("function");
        writer.value("make_long_map");
        writer.key("args");
        writer.startArray();
        // first value arg
        writer.startObject();
        writer.key("function");
        writer.value("get");
        writer.key("args");
        writer.startArray();
        writer.value(UserFields.CLEARED_CHATS.stored());
        writer.endArray();
        writer.endObject();
        // second value arg
        writer.value(StringUtils.concat(chatId, '\t', String.valueOf(ts)));
        // 3 arg - merge func
        writer.value("max");
        // 4 arg keepOrder
        writer.value("true");
        writer.endArray();
        writer.endObject();
    }

    @Override
    public String uri(String args) {
        return "/update?clearedChats&user-id=" + userId + "&chat_id=" + chatId + "&ts=" + ts + args ;
    }
}
