package ru.yandex.search.messenger.indexer;

import java.io.IOException;

import org.apache.http.HttpException;

public class ContactsIndexSession extends IndexSession {
    private final String userId;
    private final boolean reindex;
    private final long contactsVersionParam;
    private long contactsVersionGlobal = -1L;

    public ContactsIndexSession(
        final MaloRequest request,
        final String userId,
        final boolean reindex)
        throws HttpException, IOException
    {
        super(request);
        this.userId = userId;
        this.reindex = request.params().getBoolean("reindex", reindex);
        if (reindex) {
            this.contactsVersionParam = 0;
        } else {
            this.contactsVersionParam =
                request.params().getLong("contacts-version", -1L);
        }

        info(MaloYtField.INDEX_METHOD, "contacts");
        info(MaloYtField.REINDEX, Boolean.toString(this.reindex));
        info(MaloYtField.USER_ID, userId);
    }

    public ContactsIndexSession(final MaloRequest request, final String userId)
        throws HttpException, IOException
    {
        this(request, userId, false);
    }

    public String userId() {
        return userId;
    }

    public long contactsVersionGlobal() {
        return contactsVersionGlobal;
    }

    public void contactsVersionGlobal(final long version) {
        this.contactsVersionGlobal = version;
    }

    public long contactsVersionParam() {
        return contactsVersionParam;
    }

    public boolean reindex() {
        return reindex;
    }
}
