package ru.yandex.search.messenger.indexer;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.server.UpstreamStater;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;

public class GetChatMembersHandler extends MessengerChatMembersDiffHandler implements ProxyRequestHandler {
    public GetChatMembersHandler(final Malo malo, final UpstreamStater producerStater) {
        super(malo, producerStater);
    }

    @Override
    public void handle(final ProxySession session) throws HttpException, IOException {
        //String chatId = session.params().getString("chat-id");
        //getMembersDiff(chatId, 0, session, new MetaCallback(session));
    }

    private static class MetaCallback extends AbstractProxySessionCallback<JsonObject> {
        public MetaCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                JsonMap map = result.asMap();
                String status = map.getOrNull("status");

                if ("ok".equals(status)) {
                    JsonMap data = map.getMap(DATA);
                } else if ("error".equals(status)) {
                    JsonMap data = map.getMap(DATA);
                    String code = data.getOrNull("code");
                    failed(new Exception("Meta responded with code " + code));
                } else {
                    failed(new Exception("Meta responded with unknown status " + status));
                }
            } catch (JsonException je) {
                failed(je);
            }
        }
    }
}
