package ru.yandex.search.messenger.indexer;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMaloConfig
    extends ImmutableHttpProxyConfig
    implements MaloConfig
{
    private final ImmutableHttpHostConfig producer;
    private final ImmutableHttpHostConfig mailProducer;
    private final ImmutableHttpHostConfig moxy;
    private final ImmutableHttpHostConfig malo;
    private final ImmutableHttpHostConfig rca;
    private final ImmutableURIConfig cmntApi;
    private final ImmutableURIConfig chats;
    private final ImmutableURIConfig messages;
    private final ImmutableURIConfig users;
    private final String chatsService;
    private final String messagesService;
    private final String usersService;
    private final String tasksService;
    private final String mailMessagesService;
    private final String v2OrgUserService;
    private final String v2OrgChatsService;
    private final String chatsTasksService;
    private final ImmutableTvm2ClientConfig cmntApiTvm2ClientConfig;

    public ImmutableMaloConfig(
        final MaloConfig config)
        throws ConfigException
    {
        super(config);
        chats = new ImmutableURIConfig(config.chats());
        messages = new ImmutableURIConfig(config.messages());
        users = new ImmutableURIConfig(config.users());
        producer = new ImmutableHttpHostConfig(config.producer());
        moxy = new ImmutableHttpHostConfig(config.moxy());
        if (config.mailProducer() != null) {
            mailProducer = new ImmutableHttpHostConfig(config.mailProducer());
            malo = new ImmutableHttpHostConfig(config.malo());
        } else {
            mailProducer = null;
            malo = null;
        }
        if (config.rca() != null) {
            rca = new ImmutableHttpHostConfig(config.rca());
        } else {
            rca = null;
        }
        if (config.cmntApi() != null) {
            cmntApi = new ImmutableURIConfig(config.cmntApi());
            if (config.cmntApiTvm2ClientConfig() != null) {
                cmntApiTvm2ClientConfig =
                    new ImmutableTvm2ClientConfig(
                        config.cmntApiTvm2ClientConfig());
            } else {
                cmntApiTvm2ClientConfig = null;
            }
        } else {
            cmntApi = null;
            cmntApiTvm2ClientConfig = null;
        }
        chatsService = config.chatsService();
        messagesService = config.messagesService();
        usersService = config.usersService();
        tasksService = config.tasksService();
        mailMessagesService = config.mailMessagesService();
        v2OrgChatsService = config.v2OrgChatsService();
        v2OrgUserService = config.v2OrgUserService();
        chatsTasksService = config.chatsTasksService();
    }

    @Override
    public ImmutableURIConfig chats() {
        return chats;
    }

    @Override
    public String chatsService() {
        return chatsService;
    }

    @Override
    public ImmutableURIConfig messages() {
        return messages;
    }

    @Override
    public String messagesService() {
        return messagesService;
    }

    @Override
    public ImmutableURIConfig users() {
        return users;
    }

    @Override
    public String usersService() {
        return usersService;
    }

    @Override
    public String tasksService() {
        return tasksService;
    }

    @Override
    public String mailMessagesService() {
        return mailMessagesService;
    }

    @Override
    public ImmutableHttpHostConfig producer() {
        return producer;
    }

    @Override
    public ImmutableHttpHostConfig mailProducer() {
        return mailProducer;
    }

    @Override
    public ImmutableHttpHostConfig moxy() {
        return moxy;
    }

    @Override
    public ImmutableHttpHostConfig malo() {
        return malo;
    }

    @Override
    public ImmutableHttpHostConfig rca() {
        return rca;
    }

    @Override
    public ImmutableURIConfig cmntApi() {
        return cmntApi;
    }

    @Override
    public ImmutableTvm2ClientConfig cmntApiTvm2ClientConfig() {
        return cmntApiTvm2ClientConfig;
    }

    @Override
    public String v2OrgUserService() {
        return v2OrgUserService;
    }

    @Override
    public String v2OrgChatsService() {
        return v2OrgChatsService;
    }

    @Override
    public String chatsTasksService() {
        return chatsTasksService;
    }
}
