package ru.yandex.search.messenger.indexer;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class MaloConfigBuilder
    extends AbstractMaloConfigBuilder<
        MaloConfigBuilder>
{
    public MaloConfigBuilder()
        throws ConfigException
    {
        super(MaloConfigDefaults.INSTANCE);
    }

    public MaloConfigBuilder(
        final MaloConfig config)
        throws ConfigException
    {
        super(config);
    }

    public MaloConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, MaloConfigDefaults.INSTANCE);
    }

    public MaloConfigBuilder(
        final IniConfig config,
        final MaloConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public MaloConfigBuilder self() {
        return this;
    }

    public ImmutableMaloConfig build()
        throws ConfigException
    {
        return new ImmutableMaloConfig(this);
    }
}
