package ru.yandex.search.messenger.indexer;

import ru.yandex.client.tvm2.Tvm2ClientConfig;
import ru.yandex.client.tvm2.Tvm2ClientConfigDefaults;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigDefaults;
import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class MaloConfigDefaults
    extends HttpProxyConfigDefaults
    implements MaloConfig
{
    public static final MaloConfigDefaults INSTANCE =
        new MaloConfigDefaults();

    protected MaloConfigDefaults() {
    }

    @Override
    public HttpHostConfig producer() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig mailProducer() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig rca() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig cmntApi() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig moxy() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig malo() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public URIConfig chats() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public String chatsService() {
        return "messenger_chats";
    }

    @Override
    public URIConfig messages() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public String messagesService() {
        return "messenger_messages";
    }

    @Override
    public URIConfig users() {
        return URIConfigDefaults.INSTANCE;
    }

    @Override
    public String usersService() {
        return "messenger_users";
    }

    @Override
    public String tasksService() {
        return "messenger_tasks";
    }

    @Override
    public String mailMessagesService() {
        return "the_messenger";
    }

    @Override
    public String chatsTasksService() {
        return "messenger_chats_tasks";
    }

    @Override
    public String v2OrgUserService() {
        return usersService();
    }

    @Override
    public String v2OrgChatsService() {
        return chatsService();
    }

    @Override
    public Tvm2ClientConfig cmntApiTvm2ClientConfig() {
        return Tvm2ClientConfigDefaults.INSTANCE;
    }
}
