package ru.yandex.search.messenger.indexer;

import java.io.IOException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;

public class MaloRequest {
    private final UriParser uri;
    private final CgiParams params;
    private final ProxySession session;

    public MaloRequest(
        final ProxySession session,
        final UriParser uri,
        final CgiParams params)
    {
        this.uri = uri;
        this.params = params;
        this.session = session;
    }

    public MaloRequest(final ProxySession session) throws IOException {
        this(session, session.uri(), session.params());
    }

    public CgiParams params() {
        return params;
    }

    public UriParser uri() {
        return uri;
    }

    public ProxySession session() {
        return session;
    }
}
