package ru.yandex.search.messenger.indexer;

import java.io.IOException;

import org.apache.http.HttpException;

public class MessageIndexSession extends IndexSession {
    private final String chatId;
    private final String clearChatGuid;
    private final long timestamp;
    private final boolean skipTasks;
    private final boolean ignoreTaskPosition;

    //CSOFF: ParameterNumber
    public MessageIndexSession(
        final MaloRequest request,
        final String chatId,
        final long timestamp,
        final String clearChatGuid)
        throws HttpException, IOException
    {
        super(request);
        this.chatId = chatId;
        this.timestamp = timestamp;
        this.clearChatGuid = clearChatGuid;
        skipTasks =
            request.session().params().getBoolean("skip-tasks", false);
        ignoreTaskPosition =
            request.session().params().getBoolean(
                "ignore-task-position",
                false);
    }
    //CSON: ParameterNumber

    public String chatId() {
        return chatId;
    }

    public long timestamp() {
        return timestamp;
    }

    public boolean skipTasks() {
        return skipTasks;
    }

    public boolean ignoreTaskPosition() {
        return ignoreTaskPosition;
    }

    public boolean clearChatMessage() {
        return clearChatGuid != null;
    }

    public String clearChatGuid() {
        return clearChatGuid;
    }
}
