package ru.yandex.search.messenger.indexer;

import java.io.IOException;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.util.EntityUtils;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;

public class PostRequestPart extends MaloRequest {
    private final byte[] body;

    //CSOFF: ParameterNumber
    public PostRequestPart(
        final ProxySession session,
        final UriParser uri,
        final CgiParams params,
        final byte[] body)
    {
        super(session, uri, params);
        this.body = body;
    }
    //CSON: ParameterNumber

    public PostRequestPart(final ProxySession session) throws IOException {
        super(session);
        HttpEntityEnclosingRequest request =
            (HttpEntityEnclosingRequest) session.request();
        body = EntityUtils.toByteArray(request.getEntity());
    }

    public byte[] body() {
        return body;
    }
}
