package ru.yandex.search.messenger.indexer;

import ru.yandex.search.prefix.Prefix;

public abstract class PrefixedIndexableMessage extends IndexableMessage {
    protected final Prefix prefix;

    public PrefixedIndexableMessage(
        final Prefix prefix,
        final boolean addIfNotExists)
    {
        super(addIfNotExists);
        this.prefix = prefix;
    }

    @Override
    public String prefixHash() {
        return Long.toString(prefix.hash());
    }

    @Override
    public String prefix() {
        return prefix.toString();
    }
}
