package ru.yandex.search.messenger.indexer;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

import NMessengerProtocol.Message.TOutMessage;
import com.google.protobuf.Descriptors.FieldDescriptor;
import com.google.protobuf.Message;

import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonBoolean;
import ru.yandex.json.dom.JsonDouble;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonLong;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonNull;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.writer.JsonType;

public final class ProtoUtils {
    private ProtoUtils() {
    }

    public static JsonObject protoToJson(final Message proto) {
        Map<FieldDescriptor, Object> fields = proto.getAllFields();
        return fieldsToJson(fields);
    }

    private static JsonObject fieldsToJson(
        final Map<FieldDescriptor, Object> fields)
    {
        JsonMap map = new JsonMap(BasicContainerFactory.INSTANCE);
        for (Map.Entry<FieldDescriptor, Object> entry: fields.entrySet()) {
            map.put(
                entry.getKey().getName(),
                fieldToJson(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    private static JsonObject fieldToJson(
        final FieldDescriptor descriptor,
        final Object value)
    {
        JsonObject ret;
        if (descriptor.isRepeated()) {
            JsonList list = new JsonList(BasicContainerFactory.INSTANCE);
            for (Object element: (List<?>) value) {
                list.add(singleFieldToJson(descriptor, element));
            }
            ret = list;
        } else {
            ret = singleFieldToJson(descriptor, value);
        }
        return ret;
    }

    private static JsonObject singleFieldToJson(
        final FieldDescriptor descriptor,
        final Object value)
    {
        JsonObject ret;
        switch (descriptor.getJavaType()) {
            case INT:
            case LONG:
                ret = new JsonLong(((Number) value).longValue());
                break;
            case FLOAT:
            case DOUBLE:
                ret = new JsonDouble(((Number) value).doubleValue());
                break;
            case BOOLEAN:
                ret = JsonBoolean.valueOf((Boolean) value);
                break;
            case STRING:
                ret = new JsonString((String) value);
                break;
            case BYTE_STRING:
            case ENUM:
                ret = new JsonString(value.toString());
                break;
            case MESSAGE:
                ret = fieldsToJson(((Message) value).getAllFields());
                break;
            default:
                ret = JsonNull.INSTANCE;
        }
        return ret;
    }

    public static void main(final String[] args) throws Exception {
        InputStream in;
        if (args.length == 0) {
            in = System.in;
        } else {
            in = new FileInputStream(args[0]);
        }
        TOutMessage message = TOutMessage.parseFrom(in);
//        System.out.println(message.toString());
        System.out.println(
            JsonType.NORMAL.toString(protoToJson(message)));
    }
}
