package ru.yandex.search.messenger.indexer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;

public class UpdateChatInfoIndexSession extends IndexSession {
    private final String chatId;
    private final long messageTimestamp;
    private final long messageSeqNo;
    private final String fromGuid;
    private Long totalCount = null;
    private Long totalMessageCount = null;
    private Long hiddenMessageCount = null;
    private Map<String, Long> moderationInfo = null;
    private String entityId = null;
    private String namespace = null;
    private String subservice = null;
    private String parentUrl = null;
    private boolean updateChatEntityData = false;
    private String teaserData = null;

    public UpdateChatInfoIndexSession(final MaloRequest request)
        throws HttpException, IOException
    {
        super(request);
        chatId = request.params().getString("chat-id");
        messageTimestamp = request.params().getLong(
            "message-timestamp");
        messageSeqNo = request.params().getLong(
            "message-seqno",
            -1L);
        fromGuid = request.params().getString("message-from-guid", null);
    }

    public String chatId() {
        return chatId;
    }

    public long messageTimestamp() {
        return messageTimestamp;
    }

    public long messageSeqNo() {
        return messageSeqNo;
    }

    public String fromGuid() {
        return fromGuid;
    }

    public void totalMessageCount(final long totalMessageCount) {
        this.totalMessageCount = totalMessageCount;
    }

    public Long totalMessageCount() {
        return totalMessageCount;
    }

    public void hiddenMessageCount(final long hiddenMessageCount) {
        this.hiddenMessageCount = hiddenMessageCount;
    }

    public Long hiddenMessageCount() {
        return hiddenMessageCount;
    }

    public void addModerationInfo(final String action, final long count) {
        if (moderationInfo == null) {
            moderationInfo = new HashMap<>();
            totalCount = 0L;
        }
        moderationInfo.put(action, count);
        totalCount += count;
    }

    public Map<String, Long> moderationInfo() {
        return moderationInfo;
    }

    public Long totalCount() {
        return totalCount;
    }

    public String entityId() {
        return entityId;
    }

    public void entityId(final String entityId) {
        this.entityId = entityId;
    }

    public String namespace() {
        return namespace;
    }

    public void namespace(final String namespace) {
        this.namespace = namespace;
    }

    public String subservice() {
        return subservice;
    }

    public void subservice(final String subservice) {
        this.subservice = subservice;
    }
    public String parentUrl() {
        return parentUrl;
    }

    public void parentUrl(final String parentUrl) {
        this.parentUrl = parentUrl;
    }

    public boolean updateChatEntityData() {
        return this.updateChatEntityData;
    }

    public void updateChatEntityData(final boolean update) {
        this.updateChatEntityData = update;
    }

    public void teaserData(final String data) {
        this.teaserData = data;
    }

    public String teaserData() {
        return teaserData;
    }

    @Override
    public String topic() {
        return topic + "_exec";
    }
}
