package ru.yandex.search.messenger.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.http.HttpException;

public class UpdateMessageInfoIndexSession extends IndexSession {
    private final String chatId;
    private final String messageId;
    private final long messageTimestamp;
    private final String messageType;
    private final List<String> rcaUrls;
    private final Integer linksToExtractMax;

    public UpdateMessageInfoIndexSession(final MaloRequest request)
        throws HttpException, IOException
    {
        super(request);
        chatId = request.params().getString("chat-id");
        messageId = request.params().getString("message-id");
        messageTimestamp = request.params().getLong(
            "message-timestamp");
        messageType = request.params().getString("message-type");
        String rcaUrlsStr = request.params().getString("rca-url", null);
        if (rcaUrlsStr != null) {
            rcaUrls = Arrays.asList(rcaUrlsStr.split("\n"));
        } else {
            rcaUrls = new ArrayList<>();
        }
        linksToExtractMax = request.params().getInt("links_to_extract_max", 5);
    }

    public String chatId() {
        return chatId;
    }

    public String messageId() {
        return messageId;
    }

    public long messageTimestamp() {
        return messageTimestamp;
    }

    @Override
    public String topic() {
        return topic + "_mexec";
    }

    public String messageType() {
        return messageType;
    }

    public List<String> rcaUrls() {
        return rcaUrls;
    }

    public Integer linksToExtractMax() {
        return linksToExtractMax;
    }
}
