package ru.yandex.search.messenger.indexer;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;

import ru.yandex.url.processor.UrlInfo;

public class UrlCollector implements Consumer<UrlInfo> {
    private final Set<String> urls = new LinkedHashSet<String>();

    @Override
    public void accept(final UrlInfo urlInfo) {
        urls.add(urlInfo.url().toString());
    }

    public Set<String> urls() {
        return Collections.unmodifiableSet(urls);
    }
}

