package ru.yandex.search.messenger.indexer;

import ru.yandex.search.prefix.Prefix;

public abstract class UserMessage extends PrefixedIndexableMessage {
    protected final String userId;

    public UserMessage(final Prefix prefix, final String userId) {
        this(prefix, userId, false);
    }

    protected UserMessage(
        final Prefix prefix,
        final String userId,
        final boolean addIfNotExists)
    {
        super(prefix, addIfNotExists);
        this.userId = userId;
    }

    @Override
    public String id() {
        return "user_" + userId + '@' + prefix.toString();
    }

    @Override
    public String type() {
        return "user";
    }
}
