package ru.yandex.search.messenger.indexer.user.settings;

import java.util.Locale;

import ru.yandex.parser.string.EnumParser;

public enum SearchBucketSubType {
    PRIVACY,
    RESTRICTIONS,
    HIDDEN_PRIVATE_CHATS;

    public static final EnumParser<SearchBucketSubType> PARSER
        = new EnumParser<>(SearchBucketSubType.class);

    private final String name;

    SearchBucketSubType() {
        this.name = name().toLowerCase(Locale.ENGLISH);
    }

    public String bucketName() {
        return name;
    }

    public static SearchBucketSubType parse(final String value) {
        if (value == null) {
            return null;
        }

        try {
            return PARSER.apply(value);
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return bucketName();
    }
}
