package ru.yandex.search.messenger.indexer.user.settings.privacy;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.search.messenger.indexer.IndexSession;
import ru.yandex.search.messenger.indexer.MaloRequest;
import ru.yandex.search.messenger.indexer.user.settings.SearchBucketSubType;

public class SearchBucketIndexSession extends IndexSession {
    private final SearchBucketSubType subType;
    private final String guid;

    public SearchBucketIndexSession(
            final MaloRequest request,
            final SearchBucketSubType subType,
            final String guid)
            throws HttpException, IOException
    {
        super(request);

        this.subType = subType;
        this.guid = guid;
    }

    public SearchBucketSubType subType() {
        return subType;
    }

    public String userId() {
        return guid;
    }
}
