package ru.yandex.search.messenger.indexer.v2org;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.writer.Utf8JsonWriter;
import ru.yandex.search.messenger.indexer.PrefixedIndexableMessage;
import ru.yandex.search.prefix.LongPrefix;

public class DeleteDepartmentMessage extends PrefixedIndexableMessage {
    private final long depId;
    private final long orgId;

    public DeleteDepartmentMessage(final long orgId, final long depId)  {
        super(new LongPrefix(orgId), false);

        this.orgId = orgId;
        this.depId = depId;
    }

    @Override
    public String type() {
        return "department";
    }

    @Override
    public String id() {
        return "dep_" + orgId + "_" + depId;
    }

    @Override
    protected void writeDocumentFields(final Utf8JsonWriter writer) throws IOException {
    }

    @Override
    protected void writeGetFields(final Utf8JsonWriter writer, final Set<String> fields) throws IOException {
    }

    @Override
    public String uri(final String args) {
        return "/delete?dep_id=" + depId + args;
    }

    @Override
    public String toString() {
        return "DeleteDepartmentInfo{" +
                   ", depId=" + depId +
                   ", orgId=" + orgId +
                   '}';
    }
}
