package ru.yandex.search.messenger.indexer.v2org;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.Utf8JsonWriter;
import ru.yandex.search.messenger.indexer.PrefixedIndexableMessage;
import ru.yandex.search.prefix.LongPrefix;

public class DepartmentInfo extends PrefixedIndexableMessage {
    private final String depName;
    private final long depId;
    private final long orgId;
    private final JsonMap json;

    public DepartmentInfo(final JsonMap map) throws JsonException {
        super(new LongPrefix(map.getLong("organization_id")), true);

        this.orgId = map.getLong("organization_id");
        this.depId = map.getLong("department_id");
        this.depName = map.getString("name");
        this.json = map;
    }

    @Override
    public String type() {
        return "department";
    }

    @Override
    public String id() {
        return "dep_" + orgId + "_" + depId;
    }

    @Override
    protected void writeDocumentFields(final Utf8JsonWriter writer) throws IOException {
        writer.key("org_id");
        writer.value(orgId);
        writer.key("org_department_id");
        writer.value(depId);
        writer.key("org_department_name");
        writer.value(depName);
        writer.key("org_department_data");
        writer.value(JsonType.NORMAL.toString(json));
    }

    @Override
    protected void writeGetFields(final Utf8JsonWriter writer, final Set<String> fields) throws IOException {
    }

    @Override
    public String uri(final String args) {
        return "/update?db=v2org&department&org-id=" + orgId + "&depId=" + depId + args ;
    }

    @Override
    public String toString() {
        return "DepartmentInfo{" +
                   "depName='" + depName + '\'' +
                   ", depId=" + depId +
                   ", orgId=" + orgId +
                   '}';
    }
}
