package ru.yandex.search.messenger.indexer.v2org;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.Utf8JsonWriter;
import ru.yandex.search.messenger.indexer.PrefixedIndexableMessage;
import ru.yandex.search.prefix.LongPrefix;

public class GroupInfo extends PrefixedIndexableMessage {
    private final String groupName;
    private final long groupId;
    private final long orgId;
    private final JsonMap json;

    public GroupInfo(final JsonMap map) throws JsonException {
        super(new LongPrefix(map.getLong("organization_id")), true);

        this.orgId = map.getLong("organization_id");
        this.groupId = map.getLong("group_id");
        this.groupName = map.getString("name");
        this.json = map;
    }

    @Override
    public String type() {
        return "group";
    }

    @Override
    public String id() {
        return "group_" + orgId + "_" + groupId;
    }

    @Override
    protected void writeDocumentFields(final Utf8JsonWriter writer) throws IOException {
        writer.key("org_id");
        writer.value(orgId);
        writer.key("org_group_id");
        writer.value(groupId);
        writer.key("org_group_name");
        writer.value(groupName);
        writer.key("org_group_data");
        writer.value(JsonType.NORMAL.toString(json));
    }

    @Override
    protected void writeGetFields(final Utf8JsonWriter writer, final Set<String> fields) throws IOException {
    }

    @Override
    public String uri(final String args) {
        return "/update?db=v2org&group&org-id=" + orgId + "&groupId=" + groupId + args ;
    }

    @Override
    public String toString() {
        return "GroupInfo{" +
                   "groupName='" + groupName + '\'' +
                   ", groupId=" + groupId +
                   ", orgId=" + orgId +
                   '}';
    }
}
