package ru.yandex.search.messenger.indexer.v2org;

import java.io.IOException;
import java.util.Set;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.Utf8JsonWriter;
import ru.yandex.search.messenger.MessengerConstansts;
import ru.yandex.search.messenger.indexer.ChatMembersMessage;
import ru.yandex.search.prefix.LongPrefix;

public class PerUserOrgChatMembersMessage extends ChatMembersMessage {
    public static final String GET = "get";
    public static final String MAX = "max";
    public static final String CHAT_ID = "chat_id";
    public static final String DATA = "data";
    public static final String CHAT_MEMBERS = "chat_members";
    public static final String USER_CHATS = "user_chats";
    public static final String USER_CHATS_USER_ID = "user_chats_user_id";
    public static final String USER_CHATS_VERSIONS = "user_chats_versions";
    public static final String USER_CHATS_TMP = "user_chats_tmp";
    private static final String MAX_CHATS_PER_USER =
        Integer.toString(MessengerConstansts.MAX_CHATS_PER_USER);

    private final String chatId;
    private final String userId;
    private final String service;
    private final boolean remove;
    private final long orgId;
    private final LongPrefix prefix;

    public PerUserOrgChatMembersMessage(
        final String chatId,
        final String userId,
        final String service,
        final long orgId,
        final boolean remove)
    {
        super(chatId, false);
        this.prefix = new LongPrefix(orgId);
        this.chatId = chatId;
        this.userId = userId;
        this.remove = remove;
        this.orgId = orgId;
        this.service = service;
    }

    @Override
    protected void writeDocumentFields(final Utf8JsonWriter writer)
        throws IOException
    {
        writer.key(USER_CHATS);
        JsonObject addOrRemove;
        if (remove) {
            addOrRemove =
                jsonFunction(
                    "remove_set",
                    chatId,
                    jsonFunction(
                        "get",
                        USER_CHATS));
        } else {
            addOrRemove =
                jsonFunction(
                    "make_set",
                    jsonFunction(
                        "get",
                        USER_CHATS),
                    chatId,
                    MAX_CHATS_PER_USER);
        }
        jsonFunction(
            "set",
            addOrRemove)
            .writeValue(writer);
    }

    @Override
    protected void writeGetFields(
        final Utf8JsonWriter writer,
        final Set<String> fields)
        throws IOException
    {
    }

    @Override
    public String uri(final String args) {
        return "/update?chat-members-per-user&db=v2org&user-id=" + userId + "&org-id=" + orgId + "&chat-id=" + chatId + args;
    }

    @Override
    public String id() {
        return "user_" + userId + '@' + prefix();
    }

    @Override
    public String type() {
        return "user";
    }

    @Override
    public String prefixHash() {
        return Long.toString(prefix.hash());
    }

    @Override
    public String prefix() {
        return prefix.toStringFast();
    }

    @Override
    public String service() {
        return service;
    }
}
