#!/bin/bash
set -xo pipefail

export NGINX_PORT=48470
export MAIL_PRODUCER="empty-mail-producer"
export CMNT_API="empty-mail-producer"
export XMX="3G"

export PS_ABCSERVICE="pssearch"
export PS_PROJECT="messenger"
export PUSHCLIENT_DEFAULT_TOPIC="/$PS_ABCSERVICE/logs/${PS_PROJECT}-access-log"
export YT_ACCESS_LOG=/logs/malo.yt.log
export PUSHCLIENT_DEFAULT_LOG_NAME=$YT_ACCESS_LOG

case "$NANNY_SERVICE_ID" in
    messenger_search_malo_test)
        export CHATS_SERVICE=messenger_chats
        export USERS_SERVICE=messenger_users
        export MESSAGES_SERVICE=messenger_messages
        export TASKS_SERVICE=messenger_tasks
        export TVM_CLIENT_ID=2001772
        export META_API_TVM_CLIENT_ID=2000481
        export META_API_HOST=api.messenger.test.yandex.ru:443
        export MESSENGER_ROUTER_TVM_CLIENT_ID=2001077
        export MESSENGER_ROUTER_HOST=testing.l3.mssngr.yandex.net:31926
        export PRODUCER_HOST=messenger-search-producer-test.n.yandex-team.ru
        export MOXY_HOST=messenger-search-proxy.n.yandex-team.ru
        export CMNT_API=cmnt-api-test
        ;;
    messenger_search_malo_prod)
        export CHATS_SERVICE=messenger_chats
        export USERS_SERVICE=messenger_users
        export ORG_CHATS_SERVICE=messenger_org_chats
        export ORG_USERS_SERVICE=messenger_org_users
        export MESSAGES_SERVICE=messenger_messages
        export TASKS_SERVICE=messenger_tasks
        export TVM_CLIENT_ID=2001774
        export META_API_TVM_CLIENT_ID=2000482
        export META_API_HOST=messenger-internal.yandex.net:443
        export MESSENGER_ROUTER_TVM_CLIENT_ID=2001075
        export MESSENGER_ROUTER_HOST=l3.mssngr.yandex.net:31926
        export PRODUCER_HOST=messenger-producer.pers.yandex.net:22096
        export XMX="6G"
        export MOXY_HOST=messenger-search-proxy.pers.yandex.net
        export CMNT_API=cmnt-api-prod
#        export MAIL_PRODUCER="production-mail-producer"
        ;;
    messenger_search_malo_alpha)
        export CHATS_SERVICE=messenger_chats_alpha
        export USERS_SERVICE=messenger_users_alpha
        export ORG_CHATS_SERVICE=messenger_chats_alpha
        export ORG_USERS_SERVICE=messenger_users_alpha
        export MESSAGES_SERVICE=messenger_messages_alpha
        export TASKS_SERVICE=messenger_tasks_alpha
        export CHATS_TASKS_SERVICE=messenger_chats_tasks_alpha
	export TVM_CLIENT_ID=2002052
        export META_API_TVM_CLIENT_ID=2001664
        export META_API_HOST=messenger-internal.alpha.yandex.net:443
        export MESSENGER_ROUTER_TVM_CLIENT_ID=2001958
        export MESSENGER_ROUTER_HOST=alpha.l3.mssngr.yandex.net:31926
        export PRODUCER_HOST=messenger-producer.pers.yandex.net:22096
        export MOXY_HOST=messenger-search-proxy-alpha.pers.yandex.net
        export XMX="6G"
        export CMNT_API=cmnt-api-alpha
        ;;
esac


