#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')

GC_ARGS="
-XcompilationThreads1
-Xcodecache8M
-Xcodecachetotal64M
-Xmso128K
-Xmcrs64M
-Xgcpolicy:gencon
-Xjit:scratchSpaceLimit=$((64*1024)) 
-Djdk.nio.maxCachedBufferSize=$((256*1024))
-Xgcthreads$CPU_CORES
-verbose:gc
-Xverbosegclog:/dev/shm/gclogs/gc#.log,10,10000"
MEM_ARGS="-Xmx$MEMORY_LIMIT -Xms$MEMORY_LIMIT -Xmn512M"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
#ru.yandex.multistarter.MultiStarter ";" ru.yandex.dispatcher.producer.Producer messenger_producer.conf
exec $BSCONFIG_IDIR/jdk/bin/java \
    $JAVA_ARGS $GC_ARGS $NET_ARGS $MEM_ARGS \
    -Djava.library.path=. \
    -Djava.library.path=./malo_service \
    -cp $CLASSPATH  ru.yandex.search.messenger.indexer.Malo malo.conf

