#!/bin/bash
set -exo pipefail

export INDEX_DIR="/webcache/messenger_messages/index/"

export OLD_SEARCH_PORT="$BSCONFIG_IPORT"
export SEARCH_PORT="$((BSCONFIG_IPORT + 1))"
export INDEX_PORT="$((BSCONFIG_IPORT + 2))"
export DUMP_PORT="$((BSCONFIG_IPORT + 3))"
export CONSUMER_PORT="$((BSCONFIG_IPORT + 4))"
export HOSTNAME=$(hostname -s)
export LOGROTATE_DAYS=7

case "$NANNY_SERVICE_ID" in
  messenger_messages_search_backend_alpha)
    export HOSTNAME=$(hostname -f | cut -d '.' -f 1-2)
    export OLD_SEARCH_PORT="80"
    export SEARCH_PORT="81"
    export INDEX_PORT="82"
    export DUMP_PORT="83"
    export CONSUMER_PORT="84"
    ;;
  *_prod)
    export INDEX_DIR="/ssd/messenger_messages/index/"
    ;;
  *_test)
    export INDEX_DIR="/ssd/messenger_messages/index/"
    ;;
esac

export REPLICA_NAME=$(jq .leader.dynamicProperties.GENCFG_GROUP metainstance.json|tr -d '"'|tr 'A-Z_' 'a-z-')
export MTN_TAG=$(hostname -s)
export CONSUMER_PREFETCH_COUNT=5
export SERVICE_CONFIG=null.conf
export SEARCHMAP_PATH="searchmap.txt"
