#!/bin/bash
set -exo pipefail
source messages_backend_config.sh
source classpath.sh

export INUM=$(cat inum.txt || echo False)
>&2 echo "Current inum is: $INUM"

if [ "$INUM" = "False" ]
then
   >&2 echo "$(date) inum.txt does not exists. Exiting. Inum is: $INUM"
   exit 1
fi
export INUM_N=$(echo $INUM | cut -d ":" -f2)

CPU_CORES_CORRECTION=${CPU_CORES_CORRECTION:-"0.2"}
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk -v cores="$CPU_CORES_CORRECTION" '{print int($1 + cores)}')
fi


portoctl run self/low command= isolate=false controllers[cpu]=true cpu_limit=1.5c cpu_period=10ms || true
portoctl run self/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
-DMTN_TAG=$MTN_TAG
-DREPLICA_NAME=$REPLICA_NAME
"

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
export LD_LIBRARY_PATH=$BSCONFIG_IDIR:$BSCONFIG_IDIR/lstorage_service
export LD_PRELOAD=/usr/lib/libtcmalloc_minimal.so.4:$BSCONFIG_IDIR/libldpreload.so

source messages_backend_gc_args.sh
portoctl run search_backend/scripts command= isolate=false controllers[cpu]=true cpu_limit=0.3c || true
#portoctl run search_backend/low command= isolate=false controllers[cpu]=true cpu_limit=1c cpu_period=10ms || true

#MULTISTARTER_CONFIGS="\
#ru.yandex.dispatcher.consumer.ConsumerServer -config messages_backend_consumer.conf ; \
#ru.yandex.msearch.Daemon -config messages_backend.conf "

MULTISTARTER_CONFIGS="\
ru.yandex.dispatcher.consumer.ConsumerServer -config messages_backend_consumer.conf "

export INDEX_THREADS=2
export MERGE_THREADS=1
export SEARCH_OTHER_THREADS=$CPU_CORES
export SEARCH_MALO_THREADS=1
export SEARCH_EXECUTE_THREADS=1

export RECENT_THREADS=$((CPU_CORES + 3))
export FORWARD_THREADS=6
export LIMIT_SEARCH_REQUESTS=$((SEARCH_OTHER_THREADS - 1))
export LIMIT_FORWARD_REQUESTS=$((FORWARD_THREADS - 1))
export LIMIT_RECENT_REQUESTS=$((RECENT_THREADS - 1))

export SEARCH_THREADS=$((SEARCH_OTHER_THREADS + RECENT_THREADS  + SEARCH_EXECUTE_THREADS + SEARCH_MALO_THREADS))
#export SEARCH_THREADS=$((SEARCH_THREADS - INDEX_THREADS))
#export SEARCH_THREADS=$((SEARCH_THREADS - MERGE_THREADS))

#export SEARCH_THREADS=$((SEARCH_THREADS))


#exec $BSCONFIG_IDIR/jdk/bin/java \
#    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
#    -Djava.library.path=.:messages_backend \
#    -verbose:gc \
#    $NET_ARGS $GC_ARGS $APP_ARGS \
#    -DPORTO=1 \
#    -cp $CLASSPATH \
#    ru.yandex.multistarter.MultiStarter \
#    $MULTISTARTER_CONFIGS

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=.:messages_backend \
    -Djava.io.tmpdir=/logs \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.backpack_multistarter.BackpackMultistarter \
    messages_backend.conf \
    backpack_messenger.conf \
    $MULTISTARTER_CONFIGS

