#!/bin/bash
#set -ex

source messages_backend_config.sh

PORTO_NAME=$(portoctl get self absolute_name)

portoctl attach -t self/scripts $$ || true

function log() {
    echo $(date '+%Y-%m-%d %H:%M:%S.%3N')' '$*
}

log "Starting porter"
PORT=$((BSCONFIG_IPORT+2))
prevPid=-1
while true;
do
    sleep 30
    pid=$(cat pids/lucene)
    if [ "$prevPid" != "$pid" ]; then
        log "Lucene pid has been changed. Moving threads"
        pong=$(curl -s "http://localhost:$PORT/ping")
        if [ "$pong" != "pong" ]; then
            log "Lucene not started yet (/ping failed)"
            continue;
        fi

        if [ "$LIMIT_THREADS" = "True" ]; then
            log "Limiting treads are enabled in config"
            while read tid; do
                log "Moving TID: $tid"
                portoctl attach -t ${PORTO_NAME}/low $tid
            done <<< "$(top -b -n1 -H -p $pid | fgrep -e "Merger" -e "IdxSizeCalc" | awk '{print $1}')"
        else
            log "Limiting treads are disabled in config. Do not limit threads."
        fi
        prevPid=$pid
    fi
done
