package ru.yandex.ps.messenger.search;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.docprocessor.ModuleFieldsAggregator;
import ru.yandex.search.messenger.MessageFields;

public class ChatTsFilterDocProcessor implements DocProcessor {
    private static final Set<String> LOAD_FIELDS;
    protected static final String CHAT_ID_FIELD;
    protected static final String MESSAGE_TS_FIELD;

    static {
        CHAT_ID_FIELD = StringHelper.intern(MessageFields.CHAT_ID.stored());
        MESSAGE_TS_FIELD = StringHelper.intern(MessageFields.TIMESTAMP.stored());
        Set<String> fields = new LinkedHashSet<>();
        fields.add(CHAT_ID_FIELD);
        fields.add(MESSAGE_TS_FIELD);
        LOAD_FIELDS = Collections.unmodifiableSet(fields);
    }

    private final String chatId;
    private final long ts;

    private final int messageTsFieldIndex;
    private final int chatIdFieldIndex;
    private final ProcessorRequestContext context;
    private int filtered = 0;

    /**
     * FIXME This is dirty copy of postfilter
     * filter_cmp(field,operation,value)
     * agg_func concat,sum
     * @param args
     * @param context
     * @throws ParseException
     */
    public ChatTsFilterDocProcessor(
        final String args,
        final ProcessorRequestContext context)
        throws ParseException
    {
        this.context = context;
        String[] parts = args.split(",");
        if (parts.length != 2) {
            throw new ParseException("2 comma separated parts expected", 0);
        }

        this.chatId = parts[0];
        this.ts = Long.parseLong(parts[1]);
        this.messageTsFieldIndex = context.fieldToIndex().indexFor(MESSAGE_TS_FIELD);
        this.chatIdFieldIndex = context.fieldToIndex().indexFor(CHAT_ID_FIELD);
    }

    @Override
    public boolean processWithFilter(final YaDoc3 doc) throws IOException {
        if (!chatId.equalsIgnoreCase(doc.getField(chatIdFieldIndex).toString())) {
            return true;
        }

        long messageTs = doc.getField(messageTsFieldIndex).longValue();
        boolean keep = messageTs > ts;
        if (!keep) {
            filtered += 1;
        }

        return keep;
    }

    @Override
    public void process(final YaDoc3 doc) throws IOException {
        throw new IOException("Unsupported method for chat ts filter docprocessor");
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(LOAD_FIELDS, Collections.emptySet());
    }

    @Override
    public void after() {
        context.ctx().logger().info("ChatTsFilterDp " + chatId + ", filtered:" + filtered);
    }
}
