package ru.yandex.ps.messenger.search;

import java.text.ParseException;

import ru.yandex.msearch.ProcessorRequestContext;
import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.docprocessor.DocProcessorType;

public enum MessengerMessagesDocProcessorType implements DocProcessorType {
    CHAT_TS_FILTER {
        @Override
        public DocProcessor create(
            final String args,
            final ProcessorRequestContext context)
            throws ParseException
        {
            return new ChatTsFilterDocProcessor(args, context);
        }

        @Override
        public DocProcessor create(
            final String args,
            final FieldToIndex fieldToIndex)
            throws ParseException
        {
            throw new ParseException("Unsupported doc processor", 0);
        }
    };
}
