#!/bin/bash
set -xo pipefail

export TVM_API_HOST=https://tvm-api.yandex.net

case "$NANNY_SERVICE_ID" in
    messenger_*_test)
        export TVM_CLIENT_ID=2001772
        export CHATS_SERVICE=messenger_chats
        export USERS_SERVICE=messenger_users
        export MESSAGES_SERVICE=messenger_messages
        export TASKS_SERVICE=messenger_tasks
        export META_API_TVM_CLIENT_ID=2000481
        export META_API_HOST=api.messenger.test.yandex.ru:443
        export MESSENGER_ROUTER_TVM_CLIENT_ID=2001077
        export MESSENGER_ROUTER_HOST="https://mssngr-router-test.search.yandex.net:31926"
        export PRODUCER_HOST=messenger-search-producer-test.n.yandex-team.ru
        export MOXY_HOST=messenger-search-proxy.n.yandex-team.ru
        ;;
    messenger_*_prod*)
        export TVM_CLIENT_ID=2001774
        export CHATS_SERVICE=messenger_chats
        export USERS_SERVICE=messenger_users
        export MESSAGES_SERVICE=messenger_messages
        export TASKS_SERVICE=messenger_tasks
        export PRODUCER_HOST=messenger-producer.pers.yandex.net:22096
        export META_API_TVM_CLIENT_ID=2000482
        export META_API_HOST=messenger-internal.yandex.net:443
        export MESSENGER_ROUTER_TVM_CLIENT_ID=2001075
        export MESSENGER_ROUTER_HOST="https://mssngr-router.search.yandex.net:31926"
        export MOXY_HOST=messenger-search-proxy.pers.yandex.net
        ;;
    messenger_*_alpha*)
        export TVM_CLIENT_ID=2002052
        export CHATS_SERVICE=messenger_chats_alpha
        export USERS_SERVICE=messenger_users_alpha
        export MESSAGES_SERVICE=messenger_messages_alpha
        export TASKS_SERVICE=messenger_tasks_alpha
        export META_API_TVM_CLIENT_ID=2001664
        export META_API_HOST=messenger-internal.alpha.yandex.net:443
        export MESSENGER_ROUTER_TVM_CLIENT_ID=2001958
        export MESSENGER_ROUTER_HOST="https://mssngr-router-alpha.search.yandex.net:31926"
        export MOXY_HOST=messenger-search-proxy-alpha.pers.yandex.net
        export PRODUCER_HOST=messenger-producer.pers.yandex.net:22096
        ;;
esac
