package ru.yandex.search.messenger;

import java.util.Locale;

public enum ChatFields implements SearchBackendField {
    CHANNEL(FieldType.GLOBAL_STORED),
    MEMBERS(FieldType.GLOBAL_STORED),
    PRIVATE(FieldType.GLOBAL_STORED),
    PRIVATE_HIDDEN(FieldType.GLOBAL_STORED),
    DESCRIPTION(FieldType.GLOBAL_STORED),
    CHAT_ID("chat_id", "chat_id", null, "chat_id"),
    MESSAGE_COUNT(true),
    LAST_MESSAGE_TIMESTAMP(true),
    LAST_MESSAGE_DAY(false);

    private final String fieldName;
    private final String stored;
    private final String prefixed;
    private final String global;

    ChatFields(final FieldType fieldType) {
        this.fieldName = defaultFieldName();

        String global = null;
        String prefixed = null;
        String stored = null;
        switch (fieldType) {
            case GLOBAL:
                global = fieldName;
                break;
            case GLOBAL_STORED:
                global = fieldName;
                stored = fieldName;
                break;
            case PREFIXED:
                prefixed = fieldName;
                break;
            case PREFIXED_STORED:
                prefixed = fieldName;
                stored = fieldName;
                break;
            case WITH_PREFIX_ALIAS:
                prefixed = fieldName + "_p";
                break;
            case STORED_WITH_PREFIX_ALIAS:
                stored = fieldName;
                prefixed = fieldName + "_p";
                break;
        }

        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    private String defaultFieldName(){
        return "chat_" + name().toLowerCase(Locale.ENGLISH);
    }

    /**
     * Default, global = true, prefixed = false, stored = true
     */
    ChatFields() {
        this(true);
    }

    ChatFields(
        final boolean stored,
        final boolean prefixed)
    {
        this.fieldName = "chat_" + name().toLowerCase(Locale.ENGLISH);
        if (prefixed) {
            this.prefixed = fieldName;
            this.global = null;
        } else {
            this.global = fieldName;
            this.prefixed = null;
        }

        if (stored) {
            this.stored = fieldName;
        } else {
            this.stored = null;
        }
    }

    ChatFields(final String fieldName) {
        this(fieldName, fieldName);
    }

    ChatFields(final String fieldName, final String global) {
        this.fieldName = fieldName;
        this.global = global;
        this.stored = null;
        this.prefixed = null;
    }

    ChatFields(final String fieldName, final String prefixed, final String global) {
        this.fieldName = fieldName;
        this.prefixed = prefixed;
        this.global = global;
        this.stored = null;
    }

    ChatFields(
        final String fieldName,
        final String stored,
        final String prefixed,
        final String global)
    {
        this.fieldName = fieldName;
        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    ChatFields(final boolean stored) {
        this(stored, false);
    }

    @Override
    public String stored() {
        return stored;
    }

    @Override
    public String prefixed() {
        return prefixed;
    }

    @Override
    public String global() {
        return global;
    }

    @Override
    public String fieldName() {
        return fieldName;
    }
}
