package ru.yandex.search.messenger;

import java.util.Locale;

public enum MessageFields implements SearchBackendField {
    TIMESTAMP(FieldType.STORED_WITH_PREFIX_ALIAS),
    CHAT_ID(FieldType.GLOBAL_STORED),
    MODERATION_ACTION(FieldType.STORED_WITH_PREFIX_ALIAS),
    DAY(FieldType.WITH_PREFIX_ALIAS),
    SECOND(FieldType.WITH_PREFIX_ALIAS),
    MINTURE(FieldType.WITH_PREFIX_ALIAS),
    HOUR(FieldType.WITH_PREFIX_ALIAS);

    private static final String FIELD_PREFIX = "message_";

    private final String fieldName;
    private final String stored;
    private final String prefixed;
    private final String global;

    /**
     * Default, global = true, prefixed = false, stored = true
     */
    MessageFields() {
        this(true);
    }

    MessageFields(final FieldType fieldType) {
        this.fieldName = defaultFieldName();

        String global = null;
        String prefixed = null;
        String stored = null;
        switch (fieldType) {
            case GLOBAL:
                global = fieldName;
                break;
            case GLOBAL_STORED:
                global = fieldName;
                stored = fieldName;
                break;
            case PREFIXED:
                prefixed = fieldName;
                break;
            case PREFIXED_STORED:
                prefixed = fieldName;
                stored = fieldName;
                break;
            case WITH_PREFIX_ALIAS:
                prefixed = fieldName + "_p";
                break;
            case STORED_WITH_PREFIX_ALIAS:
                stored = fieldName;
                prefixed = fieldName + "_p";
                break;
        }

        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    MessageFields(
        final boolean stored,
        final boolean prefixed)
    {
        this.fieldName = defaultFieldName();
        if (prefixed) {
            this.prefixed = fieldName;
            this.global = null;
        } else {
            this.global = fieldName;
            this.prefixed = null;
        }

        if (stored) {
            this.stored = fieldName;
        } else {
            this.stored = null;
        }
    }

    MessageFields(final String prefixed, final String global, final String stored) {
        this.fieldName = defaultFieldName();
        this.prefixed = prefixed;
        this.global = global;
        this.stored = stored;
    }

    MessageFields(final String fieldName) {
        this(fieldName, fieldName);
    }

    MessageFields(final String fieldName, final String global) {
        this.fieldName = fieldName;
        this.global = global;
        this.stored = null;
        this.prefixed = null;
    }

    MessageFields(
        final String fieldName,
        final String stored,
        final String prefixed,
        final String global)
    {
        this.fieldName = fieldName;
        this.stored = stored;
        this.prefixed = prefixed;
        this.global = global;
    }

    MessageFields(final boolean stored) {
        this(stored, false);
    }

    private String defaultFieldName() {
        return FIELD_PREFIX + name().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public String stored() {
        return stored;
    }

    @Override
    public String prefixed() {
        return prefixed;
    }

    @Override
    public String global() {
        return global;
    }

    @Override
    public String fieldName() {
        return fieldName;
    }
}
